//windows 10 . Scilab 6.0.1 (64-bit)
//toolbox null

//Transient resoponse of second order system example RLC circuit
//zeta is damping ratio given by user
//If 0< zeta<1,  Damped System
//If zeta=1, Critically Damped System
//If zeta>1, Over Damped System
//If zeta=o, Undamped System
//wn is the system's natural frequency provided by user


clc
clear
t=0:0.002:1              
wn=100;

xlabel('Time')                     //Leveling x axis as time 
ylabel('Output voltage(V)')            //Leveling y axis as output voltage
title('Transient Response of Second order System')    //Title of Graph
//for under damped system
zeta=0.2
    phi=acos(zeta);
    b=sin((wn*sqrt(1-zeta^2)*t)+phi);
    C=1-(1/sqrt(1-zeta^2))*(exp(-zeta*wn*t).*b)    //output equation
    plot(t,C);
    plot(C,"b")               // ouput waveform in blue colour
    

//for over damped system
zeta1=5
    phi1=acos(zeta1);
    b1=sin((wn*sqrt(1-zeta1^2)*t)+phi1);
    C1=1-(1/sqrt(1-zeta1^2))*(exp(-zeta1*wn*t).*b1)
    plot(t,C1);
    plot(C1,"y")                //ouput waveform in yellow colour


//for critically damped system 
zeta2=0.999999
    phi2=acos(zeta2);
    b2=sin((wn*sqrt(1-zeta2^2)*t)+phi2);
    C2=1-(1/sqrt(1-zeta2^2))*(exp(-zeta2*wn*t).*b2)
    plot(t,C2);
    plot(C2,"r")                //ouput waveform in red colour


//for undamped system
zeta3=0
    phi3=acos(zeta3);
    b3=sin((wn*sqrt(1-zeta3^2)*t)+phi3);
    C3=1-(1/sqrt(1-zeta3^2))*(exp(-zeta3*wn*t).*b3)
    plot(t,C3);
    plot(C3,"g")                   //ouput waveform in green colour                  
    

legends(['C';'C1';'C2';'C3'],[2,7,5,3],opt=1)    //Legend
//xgrid(1)                                   //Grid 

